/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeCpeCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeCpeCompartmentRequest
extends BmcRequest {
    private String cpeId;
    private ChangeCpeCompartmentDetails changeCpeCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"cpeId", "changeCpeCompartmentDetails", "opcRequestId", "opcRetryToken"})
    ChangeCpeCompartmentRequest(String cpeId, ChangeCpeCompartmentDetails changeCpeCompartmentDetails, String opcRequestId, String opcRetryToken) {
        this.cpeId = cpeId;
        this.changeCpeCompartmentDetails = changeCpeCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public ChangeCpeCompartmentDetails getChangeCpeCompartmentDetails() {
        return this.changeCpeCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String cpeId;
        private ChangeCpeCompartmentDetails changeCpeCompartmentDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeCpeCompartmentRequest o) {
            this.cpeId(o.getCpeId());
            this.changeCpeCompartmentDetails(o.getChangeCpeCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeCpeCompartmentRequest build() {
            ChangeCpeCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder changeCpeCompartmentDetails(ChangeCpeCompartmentDetails changeCpeCompartmentDetails) {
            this.changeCpeCompartmentDetails = changeCpeCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeCpeCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeCpeCompartmentRequest(this.cpeId, this.changeCpeCompartmentDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeCpeCompartmentRequest.Builder(cpeId=" + this.cpeId + ", changeCpeCompartmentDetails=" + this.changeCpeCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

