/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeCrossConnectCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeCrossConnectCompartmentRequest
extends BmcRequest {
    private String crossConnectId;
    private ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"crossConnectId", "changeCrossConnectCompartmentDetails", "opcRequestId", "opcRetryToken"})
    ChangeCrossConnectCompartmentRequest(String crossConnectId, ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails, String opcRequestId, String opcRetryToken) {
        this.crossConnectId = crossConnectId;
        this.changeCrossConnectCompartmentDetails = changeCrossConnectCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public ChangeCrossConnectCompartmentDetails getChangeCrossConnectCompartmentDetails() {
        return this.changeCrossConnectCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String crossConnectId;
        private ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeCrossConnectCompartmentRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.changeCrossConnectCompartmentDetails(o.getChangeCrossConnectCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeCrossConnectCompartmentRequest build() {
            ChangeCrossConnectCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public Builder changeCrossConnectCompartmentDetails(ChangeCrossConnectCompartmentDetails changeCrossConnectCompartmentDetails) {
            this.changeCrossConnectCompartmentDetails = changeCrossConnectCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeCrossConnectCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeCrossConnectCompartmentRequest(this.crossConnectId, this.changeCrossConnectCompartmentDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeCrossConnectCompartmentRequest.Builder(crossConnectId=" + this.crossConnectId + ", changeCrossConnectCompartmentDetails=" + this.changeCrossConnectCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

