/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeDhcpOptionsCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeDhcpOptionsCompartmentRequest
extends BmcRequest {
    private String dhcpId;
    private ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"dhcpId", "changeDhcpOptionsCompartmentDetails", "opcRequestId", "opcRetryToken"})
    ChangeDhcpOptionsCompartmentRequest(String dhcpId, ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails, String opcRequestId, String opcRetryToken) {
        this.dhcpId = dhcpId;
        this.changeDhcpOptionsCompartmentDetails = changeDhcpOptionsCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDhcpId() {
        return this.dhcpId;
    }

    public ChangeDhcpOptionsCompartmentDetails getChangeDhcpOptionsCompartmentDetails() {
        return this.changeDhcpOptionsCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String dhcpId;
        private ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDhcpOptionsCompartmentRequest o) {
            this.dhcpId(o.getDhcpId());
            this.changeDhcpOptionsCompartmentDetails(o.getChangeDhcpOptionsCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDhcpOptionsCompartmentRequest build() {
            ChangeDhcpOptionsCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder changeDhcpOptionsCompartmentDetails(ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails) {
            this.changeDhcpOptionsCompartmentDetails = changeDhcpOptionsCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeDhcpOptionsCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeDhcpOptionsCompartmentRequest(this.dhcpId, this.changeDhcpOptionsCompartmentDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeDhcpOptionsCompartmentRequest.Builder(dhcpId=" + this.dhcpId + ", changeDhcpOptionsCompartmentDetails=" + this.changeDhcpOptionsCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

