/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeDrgCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeDrgCompartmentRequest
extends BmcRequest {
    private String drgId;
    private ChangeDrgCompartmentDetails changeDrgCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"drgId", "changeDrgCompartmentDetails", "opcRequestId", "opcRetryToken"})
    ChangeDrgCompartmentRequest(String drgId, ChangeDrgCompartmentDetails changeDrgCompartmentDetails, String opcRequestId, String opcRetryToken) {
        this.drgId = drgId;
        this.changeDrgCompartmentDetails = changeDrgCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDrgId() {
        return this.drgId;
    }

    public ChangeDrgCompartmentDetails getChangeDrgCompartmentDetails() {
        return this.changeDrgCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String drgId;
        private ChangeDrgCompartmentDetails changeDrgCompartmentDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDrgCompartmentRequest o) {
            this.drgId(o.getDrgId());
            this.changeDrgCompartmentDetails(o.getChangeDrgCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDrgCompartmentRequest build() {
            ChangeDrgCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder changeDrgCompartmentDetails(ChangeDrgCompartmentDetails changeDrgCompartmentDetails) {
            this.changeDrgCompartmentDetails = changeDrgCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeDrgCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeDrgCompartmentRequest(this.drgId, this.changeDrgCompartmentDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeDrgCompartmentRequest.Builder(drgId=" + this.drgId + ", changeDrgCompartmentDetails=" + this.changeDrgCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

