/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeInstanceCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeInstanceCompartmentRequest
extends BmcRequest {
    private String instanceId;
    private ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"instanceId", "changeInstanceCompartmentDetails", "ifMatch", "opcRequestId", "opcRetryToken"})
    ChangeInstanceCompartmentRequest(String instanceId, ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.instanceId = instanceId;
        this.changeInstanceCompartmentDetails = changeInstanceCompartmentDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ChangeInstanceCompartmentDetails getChangeInstanceCompartmentDetails() {
        return this.changeInstanceCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String instanceId;
        private ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeInstanceCompartmentRequest o) {
            this.instanceId(o.getInstanceId());
            this.changeInstanceCompartmentDetails(o.getChangeInstanceCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeInstanceCompartmentRequest build() {
            ChangeInstanceCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder changeInstanceCompartmentDetails(ChangeInstanceCompartmentDetails changeInstanceCompartmentDetails) {
            this.changeInstanceCompartmentDetails = changeInstanceCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeInstanceCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeInstanceCompartmentRequest(this.instanceId, this.changeInstanceCompartmentDetails, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeInstanceCompartmentRequest.Builder(instanceId=" + this.instanceId + ", changeInstanceCompartmentDetails=" + this.changeInstanceCompartmentDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

