/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeSubnetCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeSubnetCompartmentRequest
extends BmcRequest {
    private String subnetId;
    private ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"subnetId", "changeSubnetCompartmentDetails", "opcRequestId", "opcRetryToken"})
    ChangeSubnetCompartmentRequest(String subnetId, ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails, String opcRequestId, String opcRetryToken) {
        this.subnetId = subnetId;
        this.changeSubnetCompartmentDetails = changeSubnetCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public ChangeSubnetCompartmentDetails getChangeSubnetCompartmentDetails() {
        return this.changeSubnetCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String subnetId;
        private ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSubnetCompartmentRequest o) {
            this.subnetId(o.getSubnetId());
            this.changeSubnetCompartmentDetails(o.getChangeSubnetCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSubnetCompartmentRequest build() {
            ChangeSubnetCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder changeSubnetCompartmentDetails(ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails) {
            this.changeSubnetCompartmentDetails = changeSubnetCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeSubnetCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeSubnetCompartmentRequest(this.subnetId, this.changeSubnetCompartmentDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeSubnetCompartmentRequest.Builder(subnetId=" + this.subnetId + ", changeSubnetCompartmentDetails=" + this.changeSubnetCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

