/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ChangeVolumeCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeVolumeCompartmentRequest
extends BmcRequest {
    private String volumeId;
    private ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"volumeId", "changeVolumeCompartmentDetails", "opcRequestId"})
    ChangeVolumeCompartmentRequest(String volumeId, ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails, String opcRequestId) {
        this.volumeId = volumeId;
        this.changeVolumeCompartmentDetails = changeVolumeCompartmentDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public ChangeVolumeCompartmentDetails getChangeVolumeCompartmentDetails() {
        return this.changeVolumeCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String volumeId;
        private ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeVolumeCompartmentRequest o) {
            this.volumeId(o.getVolumeId());
            this.changeVolumeCompartmentDetails(o.getChangeVolumeCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeVolumeCompartmentRequest build() {
            ChangeVolumeCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder changeVolumeCompartmentDetails(ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails) {
            this.changeVolumeCompartmentDetails = changeVolumeCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ChangeVolumeCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeVolumeCompartmentRequest(this.volumeId, this.changeVolumeCompartmentDetails, this.opcRequestId);
        }

        public String toString() {
            return "ChangeVolumeCompartmentRequest.Builder(volumeId=" + this.volumeId + ", changeVolumeCompartmentDetails=" + this.changeVolumeCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

