/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateCpeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateCpeRequest
extends BmcRequest {
    private CreateCpeDetails createCpeDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createCpeDetails", "opcRetryToken"})
    CreateCpeRequest(CreateCpeDetails createCpeDetails, String opcRetryToken) {
        this.createCpeDetails = createCpeDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateCpeDetails getCreateCpeDetails() {
        return this.createCpeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateCpeDetails createCpeDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateCpeRequest o) {
            this.createCpeDetails(o.getCreateCpeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateCpeRequest build() {
            CreateCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createCpeDetails(CreateCpeDetails createCpeDetails) {
            this.createCpeDetails = createCpeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateCpeRequest buildWithoutInvocationCallback() {
            return new CreateCpeRequest(this.createCpeDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateCpeRequest.Builder(createCpeDetails=" + this.createCpeDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

