/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateCrossConnectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateCrossConnectRequest
extends BmcRequest {
    private CreateCrossConnectDetails createCrossConnectDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createCrossConnectDetails", "opcRetryToken"})
    CreateCrossConnectRequest(CreateCrossConnectDetails createCrossConnectDetails, String opcRetryToken) {
        this.createCrossConnectDetails = createCrossConnectDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateCrossConnectDetails getCreateCrossConnectDetails() {
        return this.createCrossConnectDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateCrossConnectDetails createCrossConnectDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateCrossConnectRequest o) {
            this.createCrossConnectDetails(o.getCreateCrossConnectDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateCrossConnectRequest build() {
            CreateCrossConnectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createCrossConnectDetails(CreateCrossConnectDetails createCrossConnectDetails) {
            this.createCrossConnectDetails = createCrossConnectDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateCrossConnectRequest buildWithoutInvocationCallback() {
            return new CreateCrossConnectRequest(this.createCrossConnectDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateCrossConnectRequest.Builder(createCrossConnectDetails=" + this.createCrossConnectDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

