/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateDhcpDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateDhcpOptionsRequest
extends BmcRequest {
    private CreateDhcpDetails createDhcpDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createDhcpDetails", "opcRetryToken"})
    CreateDhcpOptionsRequest(CreateDhcpDetails createDhcpDetails, String opcRetryToken) {
        this.createDhcpDetails = createDhcpDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateDhcpDetails getCreateDhcpDetails() {
        return this.createDhcpDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateDhcpDetails createDhcpDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDhcpOptionsRequest o) {
            this.createDhcpDetails(o.getCreateDhcpDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDhcpOptionsRequest build() {
            CreateDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createDhcpDetails(CreateDhcpDetails createDhcpDetails) {
            this.createDhcpDetails = createDhcpDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateDhcpOptionsRequest buildWithoutInvocationCallback() {
            return new CreateDhcpOptionsRequest(this.createDhcpDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateDhcpOptionsRequest.Builder(createDhcpDetails=" + this.createDhcpDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

