/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateImageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateImageRequest
extends BmcRequest {
    private CreateImageDetails createImageDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createImageDetails", "opcRetryToken"})
    CreateImageRequest(CreateImageDetails createImageDetails, String opcRetryToken) {
        this.createImageDetails = createImageDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateImageDetails getCreateImageDetails() {
        return this.createImageDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateImageDetails createImageDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateImageRequest o) {
            this.createImageDetails(o.getCreateImageDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateImageRequest build() {
            CreateImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createImageDetails(CreateImageDetails createImageDetails) {
            this.createImageDetails = createImageDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateImageRequest buildWithoutInvocationCallback() {
            return new CreateImageRequest(this.createImageDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateImageRequest.Builder(createImageDetails=" + this.createImageDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

