/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateInstanceConfigurationBase;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateInstanceConfigurationRequest
extends BmcRequest {
    private CreateInstanceConfigurationBase createInstanceConfiguration;
    private String opcRetryToken;

    @ConstructorProperties(value={"createInstanceConfiguration", "opcRetryToken"})
    CreateInstanceConfigurationRequest(CreateInstanceConfigurationBase createInstanceConfiguration, String opcRetryToken) {
        this.createInstanceConfiguration = createInstanceConfiguration;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateInstanceConfigurationBase getCreateInstanceConfiguration() {
        return this.createInstanceConfiguration;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateInstanceConfigurationBase createInstanceConfiguration;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateInstanceConfigurationRequest o) {
            this.createInstanceConfiguration(o.getCreateInstanceConfiguration());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateInstanceConfigurationRequest build() {
            CreateInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createInstanceConfiguration(CreateInstanceConfigurationBase createInstanceConfiguration) {
            this.createInstanceConfiguration = createInstanceConfiguration;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateInstanceConfigurationRequest buildWithoutInvocationCallback() {
            return new CreateInstanceConfigurationRequest(this.createInstanceConfiguration, this.opcRetryToken);
        }

        public String toString() {
            return "CreateInstanceConfigurationRequest.Builder(createInstanceConfiguration=" + this.createInstanceConfiguration + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

