/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateInstancePoolDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateInstancePoolRequest
extends BmcRequest {
    private CreateInstancePoolDetails createInstancePoolDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createInstancePoolDetails", "opcRetryToken"})
    CreateInstancePoolRequest(CreateInstancePoolDetails createInstancePoolDetails, String opcRetryToken) {
        this.createInstancePoolDetails = createInstancePoolDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateInstancePoolDetails getCreateInstancePoolDetails() {
        return this.createInstancePoolDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateInstancePoolDetails createInstancePoolDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateInstancePoolRequest o) {
            this.createInstancePoolDetails(o.getCreateInstancePoolDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateInstancePoolRequest build() {
            CreateInstancePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createInstancePoolDetails(CreateInstancePoolDetails createInstancePoolDetails) {
            this.createInstancePoolDetails = createInstancePoolDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateInstancePoolRequest buildWithoutInvocationCallback() {
            return new CreateInstancePoolRequest(this.createInstancePoolDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateInstancePoolRequest.Builder(createInstancePoolDetails=" + this.createInstancePoolDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

