/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CreateVolumeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateVolumeRequest
extends BmcRequest {
    private CreateVolumeDetails createVolumeDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"createVolumeDetails", "opcRetryToken"})
    CreateVolumeRequest(CreateVolumeDetails createVolumeDetails, String opcRetryToken) {
        this.createVolumeDetails = createVolumeDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateVolumeDetails getCreateVolumeDetails() {
        return this.createVolumeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateVolumeDetails createVolumeDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateVolumeRequest o) {
            this.createVolumeDetails(o.getCreateVolumeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateVolumeRequest build() {
            CreateVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createVolumeDetails(CreateVolumeDetails createVolumeDetails) {
            this.createVolumeDetails = createVolumeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateVolumeRequest buildWithoutInvocationCallback() {
            return new CreateVolumeRequest(this.createVolumeDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CreateVolumeRequest.Builder(createVolumeDetails=" + this.createVolumeDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

