/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteAppCatalogSubscriptionRequest
extends BmcRequest {
    private String listingId;
    private String compartmentId;
    private String resourceVersion;

    @ConstructorProperties(value={"listingId", "compartmentId", "resourceVersion"})
    DeleteAppCatalogSubscriptionRequest(String listingId, String compartmentId, String resourceVersion) {
        this.listingId = listingId;
        this.compartmentId = compartmentId;
        this.resourceVersion = resourceVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public static class Builder {
        private String listingId;
        private String compartmentId;
        private String resourceVersion;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAppCatalogSubscriptionRequest o) {
            this.listingId(o.getListingId());
            this.compartmentId(o.getCompartmentId());
            this.resourceVersion(o.getResourceVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAppCatalogSubscriptionRequest build() {
            DeleteAppCatalogSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public DeleteAppCatalogSubscriptionRequest buildWithoutInvocationCallback() {
            return new DeleteAppCatalogSubscriptionRequest(this.listingId, this.compartmentId, this.resourceVersion);
        }

        public String toString() {
            return "DeleteAppCatalogSubscriptionRequest.Builder(listingId=" + this.listingId + ", compartmentId=" + this.compartmentId + ", resourceVersion=" + this.resourceVersion + ")";
        }
    }
}

