/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteBootVolumeRequest
extends BmcRequest {
    private String bootVolumeId;
    private String ifMatch;

    @ConstructorProperties(value={"bootVolumeId", "ifMatch"})
    DeleteBootVolumeRequest(String bootVolumeId, String ifMatch) {
        this.bootVolumeId = bootVolumeId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBootVolumeId() {
        return this.bootVolumeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String bootVolumeId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBootVolumeRequest o) {
            this.bootVolumeId(o.getBootVolumeId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBootVolumeRequest build() {
            DeleteBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bootVolumeId(String bootVolumeId) {
            this.bootVolumeId = bootVolumeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteBootVolumeRequest buildWithoutInvocationCallback() {
            return new DeleteBootVolumeRequest(this.bootVolumeId, this.ifMatch);
        }

        public String toString() {
            return "DeleteBootVolumeRequest.Builder(bootVolumeId=" + this.bootVolumeId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

