/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConsoleHistoryRequest
extends BmcRequest {
    private String instanceConsoleHistoryId;
    private String ifMatch;

    @ConstructorProperties(value={"instanceConsoleHistoryId", "ifMatch"})
    DeleteConsoleHistoryRequest(String instanceConsoleHistoryId, String ifMatch) {
        this.instanceConsoleHistoryId = instanceConsoleHistoryId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceConsoleHistoryId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConsoleHistoryRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConsoleHistoryRequest build() {
            DeleteConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteConsoleHistoryRequest buildWithoutInvocationCallback() {
            return new DeleteConsoleHistoryRequest(this.instanceConsoleHistoryId, this.ifMatch);
        }

        public String toString() {
            return "DeleteConsoleHistoryRequest.Builder(instanceConsoleHistoryId=" + this.instanceConsoleHistoryId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

