/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteCpeRequest
extends BmcRequest {
    private String cpeId;
    private String ifMatch;

    @ConstructorProperties(value={"cpeId", "ifMatch"})
    DeleteCpeRequest(String cpeId, String ifMatch) {
        this.cpeId = cpeId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String cpeId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCpeRequest o) {
            this.cpeId(o.getCpeId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCpeRequest build() {
            DeleteCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteCpeRequest buildWithoutInvocationCallback() {
            return new DeleteCpeRequest(this.cpeId, this.ifMatch);
        }

        public String toString() {
            return "DeleteCpeRequest.Builder(cpeId=" + this.cpeId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

