/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteCrossConnectGroupRequest
extends BmcRequest {
    private String crossConnectGroupId;
    private String ifMatch;

    @ConstructorProperties(value={"crossConnectGroupId", "ifMatch"})
    DeleteCrossConnectGroupRequest(String crossConnectGroupId, String ifMatch) {
        this.crossConnectGroupId = crossConnectGroupId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectGroupId() {
        return this.crossConnectGroupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String crossConnectGroupId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCrossConnectGroupRequest o) {
            this.crossConnectGroupId(o.getCrossConnectGroupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCrossConnectGroupRequest build() {
            DeleteCrossConnectGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder crossConnectGroupId(String crossConnectGroupId) {
            this.crossConnectGroupId = crossConnectGroupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteCrossConnectGroupRequest buildWithoutInvocationCallback() {
            return new DeleteCrossConnectGroupRequest(this.crossConnectGroupId, this.ifMatch);
        }

        public String toString() {
            return "DeleteCrossConnectGroupRequest.Builder(crossConnectGroupId=" + this.crossConnectGroupId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

