/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDedicatedVmHostRequest
extends BmcRequest {
    private String dedicatedVmHostId;
    private String opcRequestId;

    @ConstructorProperties(value={"dedicatedVmHostId", "opcRequestId"})
    DeleteDedicatedVmHostRequest(String dedicatedVmHostId, String opcRequestId) {
        this.dedicatedVmHostId = dedicatedVmHostId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDedicatedVmHostId() {
        return this.dedicatedVmHostId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String dedicatedVmHostId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDedicatedVmHostRequest o) {
            this.dedicatedVmHostId(o.getDedicatedVmHostId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDedicatedVmHostRequest build() {
            DeleteDedicatedVmHostRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dedicatedVmHostId(String dedicatedVmHostId) {
            this.dedicatedVmHostId = dedicatedVmHostId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDedicatedVmHostRequest buildWithoutInvocationCallback() {
            return new DeleteDedicatedVmHostRequest(this.dedicatedVmHostId, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDedicatedVmHostRequest.Builder(dedicatedVmHostId=" + this.dedicatedVmHostId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

