/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDhcpOptionsRequest
extends BmcRequest {
    private String dhcpId;
    private String ifMatch;

    @ConstructorProperties(value={"dhcpId", "ifMatch"})
    DeleteDhcpOptionsRequest(String dhcpId, String ifMatch) {
        this.dhcpId = dhcpId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDhcpId() {
        return this.dhcpId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String dhcpId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDhcpOptionsRequest o) {
            this.dhcpId(o.getDhcpId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDhcpOptionsRequest build() {
            DeleteDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteDhcpOptionsRequest buildWithoutInvocationCallback() {
            return new DeleteDhcpOptionsRequest(this.dhcpId, this.ifMatch);
        }

        public String toString() {
            return "DeleteDhcpOptionsRequest.Builder(dhcpId=" + this.dhcpId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

