/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDrgAttachmentRequest
extends BmcRequest {
    private String drgAttachmentId;
    private String ifMatch;

    @ConstructorProperties(value={"drgAttachmentId", "ifMatch"})
    DeleteDrgAttachmentRequest(String drgAttachmentId, String ifMatch) {
        this.drgAttachmentId = drgAttachmentId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDrgAttachmentId() {
        return this.drgAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String drgAttachmentId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDrgAttachmentRequest o) {
            this.drgAttachmentId(o.getDrgAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDrgAttachmentRequest build() {
            DeleteDrgAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder drgAttachmentId(String drgAttachmentId) {
            this.drgAttachmentId = drgAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteDrgAttachmentRequest buildWithoutInvocationCallback() {
            return new DeleteDrgAttachmentRequest(this.drgAttachmentId, this.ifMatch);
        }

        public String toString() {
            return "DeleteDrgAttachmentRequest.Builder(drgAttachmentId=" + this.drgAttachmentId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

