/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDrgRequest
extends BmcRequest {
    private String drgId;
    private String ifMatch;

    @ConstructorProperties(value={"drgId", "ifMatch"})
    DeleteDrgRequest(String drgId, String ifMatch) {
        this.drgId = drgId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDrgId() {
        return this.drgId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String drgId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDrgRequest o) {
            this.drgId(o.getDrgId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDrgRequest build() {
            DeleteDrgRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteDrgRequest buildWithoutInvocationCallback() {
            return new DeleteDrgRequest(this.drgId, this.ifMatch);
        }

        public String toString() {
            return "DeleteDrgRequest.Builder(drgId=" + this.drgId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

