/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteIPSecConnectionRequest
extends BmcRequest {
    private String ipscId;
    private String ifMatch;

    @ConstructorProperties(value={"ipscId", "ifMatch"})
    DeleteIPSecConnectionRequest(String ipscId, String ifMatch) {
        this.ipscId = ipscId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIpscId() {
        return this.ipscId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String ipscId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteIPSecConnectionRequest o) {
            this.ipscId(o.getIpscId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteIPSecConnectionRequest build() {
            DeleteIPSecConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteIPSecConnectionRequest buildWithoutInvocationCallback() {
            return new DeleteIPSecConnectionRequest(this.ipscId, this.ifMatch);
        }

        public String toString() {
            return "DeleteIPSecConnectionRequest.Builder(ipscId=" + this.ipscId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

