/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteImageRequest
extends BmcRequest {
    private String imageId;
    private String ifMatch;

    @ConstructorProperties(value={"imageId", "ifMatch"})
    DeleteImageRequest(String imageId, String ifMatch) {
        this.imageId = imageId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String imageId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteImageRequest o) {
            this.imageId(o.getImageId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteImageRequest build() {
            DeleteImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteImageRequest buildWithoutInvocationCallback() {
            return new DeleteImageRequest(this.imageId, this.ifMatch);
        }

        public String toString() {
            return "DeleteImageRequest.Builder(imageId=" + this.imageId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

