/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteInstanceConsoleConnectionRequest
extends BmcRequest {
    private String instanceConsoleConnectionId;
    private String ifMatch;

    @ConstructorProperties(value={"instanceConsoleConnectionId", "ifMatch"})
    DeleteInstanceConsoleConnectionRequest(String instanceConsoleConnectionId, String ifMatch) {
        this.instanceConsoleConnectionId = instanceConsoleConnectionId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleConnectionId() {
        return this.instanceConsoleConnectionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceConsoleConnectionId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteInstanceConsoleConnectionRequest o) {
            this.instanceConsoleConnectionId(o.getInstanceConsoleConnectionId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteInstanceConsoleConnectionRequest build() {
            DeleteInstanceConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleConnectionId(String instanceConsoleConnectionId) {
            this.instanceConsoleConnectionId = instanceConsoleConnectionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteInstanceConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new DeleteInstanceConsoleConnectionRequest(this.instanceConsoleConnectionId, this.ifMatch);
        }

        public String toString() {
            return "DeleteInstanceConsoleConnectionRequest.Builder(instanceConsoleConnectionId=" + this.instanceConsoleConnectionId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

