/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteInternetGatewayRequest
extends BmcRequest {
    private String igId;
    private String ifMatch;

    @ConstructorProperties(value={"igId", "ifMatch"})
    DeleteInternetGatewayRequest(String igId, String ifMatch) {
        this.igId = igId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIgId() {
        return this.igId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String igId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteInternetGatewayRequest o) {
            this.igId(o.getIgId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteInternetGatewayRequest build() {
            DeleteInternetGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder igId(String igId) {
            this.igId = igId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteInternetGatewayRequest buildWithoutInvocationCallback() {
            return new DeleteInternetGatewayRequest(this.igId, this.ifMatch);
        }

        public String toString() {
            return "DeleteInternetGatewayRequest.Builder(igId=" + this.igId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

