/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteNatGatewayRequest
extends BmcRequest {
    private String natGatewayId;
    private String ifMatch;

    @ConstructorProperties(value={"natGatewayId", "ifMatch"})
    DeleteNatGatewayRequest(String natGatewayId, String ifMatch) {
        this.natGatewayId = natGatewayId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String natGatewayId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNatGatewayRequest o) {
            this.natGatewayId(o.getNatGatewayId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNatGatewayRequest build() {
            DeleteNatGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteNatGatewayRequest buildWithoutInvocationCallback() {
            return new DeleteNatGatewayRequest(this.natGatewayId, this.ifMatch);
        }

        public String toString() {
            return "DeleteNatGatewayRequest.Builder(natGatewayId=" + this.natGatewayId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

