/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteNetworkSecurityGroupRequest
extends BmcRequest {
    private String networkSecurityGroupId;
    private String ifMatch;

    @ConstructorProperties(value={"networkSecurityGroupId", "ifMatch"})
    DeleteNetworkSecurityGroupRequest(String networkSecurityGroupId, String ifMatch) {
        this.networkSecurityGroupId = networkSecurityGroupId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String networkSecurityGroupId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNetworkSecurityGroupRequest o) {
            this.networkSecurityGroupId(o.getNetworkSecurityGroupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNetworkSecurityGroupRequest build() {
            DeleteNetworkSecurityGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkSecurityGroupId(String networkSecurityGroupId) {
            this.networkSecurityGroupId = networkSecurityGroupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteNetworkSecurityGroupRequest buildWithoutInvocationCallback() {
            return new DeleteNetworkSecurityGroupRequest(this.networkSecurityGroupId, this.ifMatch);
        }

        public String toString() {
            return "DeleteNetworkSecurityGroupRequest.Builder(networkSecurityGroupId=" + this.networkSecurityGroupId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

