/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeletePrivateIpRequest
extends BmcRequest {
    private String privateIpId;
    private String ifMatch;

    @ConstructorProperties(value={"privateIpId", "ifMatch"})
    DeletePrivateIpRequest(String privateIpId, String ifMatch) {
        this.privateIpId = privateIpId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String privateIpId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePrivateIpRequest o) {
            this.privateIpId(o.getPrivateIpId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePrivateIpRequest build() {
            DeletePrivateIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeletePrivateIpRequest buildWithoutInvocationCallback() {
            return new DeletePrivateIpRequest(this.privateIpId, this.ifMatch);
        }

        public String toString() {
            return "DeletePrivateIpRequest.Builder(privateIpId=" + this.privateIpId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

