/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeletePublicIpRequest
extends BmcRequest {
    private String publicIpId;
    private String ifMatch;

    @ConstructorProperties(value={"publicIpId", "ifMatch"})
    DeletePublicIpRequest(String publicIpId, String ifMatch) {
        this.publicIpId = publicIpId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublicIpId() {
        return this.publicIpId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String publicIpId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePublicIpRequest o) {
            this.publicIpId(o.getPublicIpId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePublicIpRequest build() {
            DeletePublicIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publicIpId(String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeletePublicIpRequest buildWithoutInvocationCallback() {
            return new DeletePublicIpRequest(this.publicIpId, this.ifMatch);
        }

        public String toString() {
            return "DeletePublicIpRequest.Builder(publicIpId=" + this.publicIpId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

