/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteRouteTableRequest
extends BmcRequest {
    private String rtId;
    private String ifMatch;

    @ConstructorProperties(value={"rtId", "ifMatch"})
    DeleteRouteTableRequest(String rtId, String ifMatch) {
        this.rtId = rtId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRtId() {
        return this.rtId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String rtId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRouteTableRequest build() {
            DeleteRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteRouteTableRequest buildWithoutInvocationCallback() {
            return new DeleteRouteTableRequest(this.rtId, this.ifMatch);
        }

        public String toString() {
            return "DeleteRouteTableRequest.Builder(rtId=" + this.rtId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

