/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSecurityListRequest
extends BmcRequest {
    private String securityListId;
    private String ifMatch;

    @ConstructorProperties(value={"securityListId", "ifMatch"})
    DeleteSecurityListRequest(String securityListId, String ifMatch) {
        this.securityListId = securityListId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecurityListId() {
        return this.securityListId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String securityListId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSecurityListRequest o) {
            this.securityListId(o.getSecurityListId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSecurityListRequest build() {
            DeleteSecurityListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSecurityListRequest buildWithoutInvocationCallback() {
            return new DeleteSecurityListRequest(this.securityListId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSecurityListRequest.Builder(securityListId=" + this.securityListId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

