/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteServiceGatewayRequest
extends BmcRequest {
    private String serviceGatewayId;
    private String ifMatch;

    @ConstructorProperties(value={"serviceGatewayId", "ifMatch"})
    DeleteServiceGatewayRequest(String serviceGatewayId, String ifMatch) {
        this.serviceGatewayId = serviceGatewayId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String serviceGatewayId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteServiceGatewayRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteServiceGatewayRequest build() {
            DeleteServiceGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteServiceGatewayRequest buildWithoutInvocationCallback() {
            return new DeleteServiceGatewayRequest(this.serviceGatewayId, this.ifMatch);
        }

        public String toString() {
            return "DeleteServiceGatewayRequest.Builder(serviceGatewayId=" + this.serviceGatewayId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

