/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSubnetRequest
extends BmcRequest {
    private String subnetId;
    private String ifMatch;

    @ConstructorProperties(value={"subnetId", "ifMatch"})
    DeleteSubnetRequest(String subnetId, String ifMatch) {
        this.subnetId = subnetId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String subnetId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSubnetRequest o) {
            this.subnetId(o.getSubnetId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSubnetRequest build() {
            DeleteSubnetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSubnetRequest buildWithoutInvocationCallback() {
            return new DeleteSubnetRequest(this.subnetId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSubnetRequest.Builder(subnetId=" + this.subnetId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

