/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteVirtualCircuitRequest
extends BmcRequest {
    private String virtualCircuitId;
    private String ifMatch;

    @ConstructorProperties(value={"virtualCircuitId", "ifMatch"})
    DeleteVirtualCircuitRequest(String virtualCircuitId, String ifMatch) {
        this.virtualCircuitId = virtualCircuitId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String virtualCircuitId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteVirtualCircuitRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteVirtualCircuitRequest build() {
            DeleteVirtualCircuitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteVirtualCircuitRequest buildWithoutInvocationCallback() {
            return new DeleteVirtualCircuitRequest(this.virtualCircuitId, this.ifMatch);
        }

        public String toString() {
            return "DeleteVirtualCircuitRequest.Builder(virtualCircuitId=" + this.virtualCircuitId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

