/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteVolumeGroupRequest
extends BmcRequest {
    private String volumeGroupId;
    private String ifMatch;

    @ConstructorProperties(value={"volumeGroupId", "ifMatch"})
    DeleteVolumeGroupRequest(String volumeGroupId, String ifMatch) {
        this.volumeGroupId = volumeGroupId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String volumeGroupId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteVolumeGroupRequest o) {
            this.volumeGroupId(o.getVolumeGroupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteVolumeGroupRequest build() {
            DeleteVolumeGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteVolumeGroupRequest buildWithoutInvocationCallback() {
            return new DeleteVolumeGroupRequest(this.volumeGroupId, this.ifMatch);
        }

        public String toString() {
            return "DeleteVolumeGroupRequest.Builder(volumeGroupId=" + this.volumeGroupId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

