/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DetachBootVolumeRequest
extends BmcRequest {
    private String bootVolumeAttachmentId;
    private String ifMatch;

    @ConstructorProperties(value={"bootVolumeAttachmentId", "ifMatch"})
    DetachBootVolumeRequest(String bootVolumeAttachmentId, String ifMatch) {
        this.bootVolumeAttachmentId = bootVolumeAttachmentId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBootVolumeAttachmentId() {
        return this.bootVolumeAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String bootVolumeAttachmentId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachBootVolumeRequest o) {
            this.bootVolumeAttachmentId(o.getBootVolumeAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachBootVolumeRequest build() {
            DetachBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bootVolumeAttachmentId(String bootVolumeAttachmentId) {
            this.bootVolumeAttachmentId = bootVolumeAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DetachBootVolumeRequest buildWithoutInvocationCallback() {
            return new DetachBootVolumeRequest(this.bootVolumeAttachmentId, this.ifMatch);
        }

        public String toString() {
            return "DetachBootVolumeRequest.Builder(bootVolumeAttachmentId=" + this.bootVolumeAttachmentId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

