/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.DetachLoadBalancerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DetachLoadBalancerRequest
extends BmcRequest {
    private String instancePoolId;
    private DetachLoadBalancerDetails detachLoadBalancerDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instancePoolId", "detachLoadBalancerDetails", "opcRetryToken", "ifMatch"})
    DetachLoadBalancerRequest(String instancePoolId, DetachLoadBalancerDetails detachLoadBalancerDetails, String opcRetryToken, String ifMatch) {
        this.instancePoolId = instancePoolId;
        this.detachLoadBalancerDetails = detachLoadBalancerDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public DetachLoadBalancerDetails getDetachLoadBalancerDetails() {
        return this.detachLoadBalancerDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instancePoolId;
        private DetachLoadBalancerDetails detachLoadBalancerDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachLoadBalancerRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.detachLoadBalancerDetails(o.getDetachLoadBalancerDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachLoadBalancerRequest build() {
            DetachLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder detachLoadBalancerDetails(DetachLoadBalancerDetails detachLoadBalancerDetails) {
            this.detachLoadBalancerDetails = detachLoadBalancerDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DetachLoadBalancerRequest buildWithoutInvocationCallback() {
            return new DetachLoadBalancerRequest(this.instancePoolId, this.detachLoadBalancerDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "DetachLoadBalancerRequest.Builder(instancePoolId=" + this.instancePoolId + ", detachLoadBalancerDetails=" + this.detachLoadBalancerDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

