/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ServiceIdRequestDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DetachServiceIdRequest
extends BmcRequest {
    private String serviceGatewayId;
    private ServiceIdRequestDetails detachServiceDetails;
    private String ifMatch;

    @ConstructorProperties(value={"serviceGatewayId", "detachServiceDetails", "ifMatch"})
    DetachServiceIdRequest(String serviceGatewayId, ServiceIdRequestDetails detachServiceDetails, String ifMatch) {
        this.serviceGatewayId = serviceGatewayId;
        this.detachServiceDetails = detachServiceDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public ServiceIdRequestDetails getDetachServiceDetails() {
        return this.detachServiceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String serviceGatewayId;
        private ServiceIdRequestDetails detachServiceDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachServiceIdRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.detachServiceDetails(o.getDetachServiceDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachServiceIdRequest build() {
            DetachServiceIdRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder detachServiceDetails(ServiceIdRequestDetails detachServiceDetails) {
            this.detachServiceDetails = detachServiceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DetachServiceIdRequest buildWithoutInvocationCallback() {
            return new DetachServiceIdRequest(this.serviceGatewayId, this.detachServiceDetails, this.ifMatch);
        }

        public String toString() {
            return "DetachServiceIdRequest.Builder(serviceGatewayId=" + this.serviceGatewayId + ", detachServiceDetails=" + this.detachServiceDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

