/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DetachVolumeRequest
extends BmcRequest {
    private String volumeAttachmentId;
    private String ifMatch;

    @ConstructorProperties(value={"volumeAttachmentId", "ifMatch"})
    DetachVolumeRequest(String volumeAttachmentId, String ifMatch) {
        this.volumeAttachmentId = volumeAttachmentId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeAttachmentId() {
        return this.volumeAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String volumeAttachmentId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachVolumeRequest o) {
            this.volumeAttachmentId(o.getVolumeAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachVolumeRequest build() {
            DetachVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeAttachmentId(String volumeAttachmentId) {
            this.volumeAttachmentId = volumeAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DetachVolumeRequest buildWithoutInvocationCallback() {
            return new DetachVolumeRequest(this.volumeAttachmentId, this.ifMatch);
        }

        public String toString() {
            return "DetachVolumeRequest.Builder(volumeAttachmentId=" + this.volumeAttachmentId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

