/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ExportImageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ExportImageRequest
extends BmcRequest {
    private String imageId;
    private ExportImageDetails exportImageDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"imageId", "exportImageDetails", "opcRetryToken", "ifMatch"})
    ExportImageRequest(String imageId, ExportImageDetails exportImageDetails, String opcRetryToken, String ifMatch) {
        this.imageId = imageId;
        this.exportImageDetails = exportImageDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImageId() {
        return this.imageId;
    }

    public ExportImageDetails getExportImageDetails() {
        return this.exportImageDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String imageId;
        private ExportImageDetails exportImageDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportImageRequest o) {
            this.imageId(o.getImageId());
            this.exportImageDetails(o.getExportImageDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportImageRequest build() {
            ExportImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder exportImageDetails(ExportImageDetails exportImageDetails) {
            this.exportImageDetails = exportImageDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public ExportImageRequest buildWithoutInvocationCallback() {
            return new ExportImageRequest(this.imageId, this.exportImageDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "ExportImageRequest.Builder(imageId=" + this.imageId + ", exportImageDetails=" + this.exportImageDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

