/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAppCatalogListingAgreementsRequest
extends BmcRequest {
    private String listingId;
    private String resourceVersion;

    @ConstructorProperties(value={"listingId", "resourceVersion"})
    GetAppCatalogListingAgreementsRequest(String listingId, String resourceVersion) {
        this.listingId = listingId;
        this.resourceVersion = resourceVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public static class Builder {
        private String listingId;
        private String resourceVersion;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAppCatalogListingAgreementsRequest o) {
            this.listingId(o.getListingId());
            this.resourceVersion(o.getResourceVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAppCatalogListingAgreementsRequest build() {
            GetAppCatalogListingAgreementsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public GetAppCatalogListingAgreementsRequest buildWithoutInvocationCallback() {
            return new GetAppCatalogListingAgreementsRequest(this.listingId, this.resourceVersion);
        }

        public String toString() {
            return "GetAppCatalogListingAgreementsRequest.Builder(listingId=" + this.listingId + ", resourceVersion=" + this.resourceVersion + ")";
        }
    }
}

