/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAppCatalogListingRequest
extends BmcRequest {
    private String listingId;

    @ConstructorProperties(value={"listingId"})
    GetAppCatalogListingRequest(String listingId) {
        this.listingId = listingId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public static class Builder {
        private String listingId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAppCatalogListingRequest o) {
            this.listingId(o.getListingId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAppCatalogListingRequest build() {
            GetAppCatalogListingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public GetAppCatalogListingRequest buildWithoutInvocationCallback() {
            return new GetAppCatalogListingRequest(this.listingId);
        }

        public String toString() {
            return "GetAppCatalogListingRequest.Builder(listingId=" + this.listingId + ")";
        }
    }
}

