/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBootVolumeRequest
extends BmcRequest {
    private String bootVolumeId;

    @ConstructorProperties(value={"bootVolumeId"})
    GetBootVolumeRequest(String bootVolumeId) {
        this.bootVolumeId = bootVolumeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBootVolumeId() {
        return this.bootVolumeId;
    }

    public static class Builder {
        private String bootVolumeId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBootVolumeRequest o) {
            this.bootVolumeId(o.getBootVolumeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBootVolumeRequest build() {
            GetBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bootVolumeId(String bootVolumeId) {
            this.bootVolumeId = bootVolumeId;
            return this;
        }

        public GetBootVolumeRequest buildWithoutInvocationCallback() {
            return new GetBootVolumeRequest(this.bootVolumeId);
        }

        public String toString() {
            return "GetBootVolumeRequest.Builder(bootVolumeId=" + this.bootVolumeId + ")";
        }
    }
}

