/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConsoleHistoryContentRequest
extends BmcRequest {
    private String instanceConsoleHistoryId;
    private Integer offset;
    private Integer length;

    @ConstructorProperties(value={"instanceConsoleHistoryId", "offset", "length"})
    GetConsoleHistoryContentRequest(String instanceConsoleHistoryId, Integer offset, Integer length) {
        this.instanceConsoleHistoryId = instanceConsoleHistoryId;
        this.offset = offset;
        this.length = length;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLength() {
        return this.length;
    }

    public static class Builder {
        private String instanceConsoleHistoryId;
        private Integer offset;
        private Integer length;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleHistoryContentRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.offset(o.getOffset());
            this.length(o.getLength());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleHistoryContentRequest build() {
            GetConsoleHistoryContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public GetConsoleHistoryContentRequest buildWithoutInvocationCallback() {
            return new GetConsoleHistoryContentRequest(this.instanceConsoleHistoryId, this.offset, this.length);
        }

        public String toString() {
            return "GetConsoleHistoryContentRequest.Builder(instanceConsoleHistoryId=" + this.instanceConsoleHistoryId + ", offset=" + this.offset + ", length=" + this.length + ")";
        }
    }
}

