/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConsoleHistoryRequest
extends BmcRequest {
    private String instanceConsoleHistoryId;

    @ConstructorProperties(value={"instanceConsoleHistoryId"})
    GetConsoleHistoryRequest(String instanceConsoleHistoryId) {
        this.instanceConsoleHistoryId = instanceConsoleHistoryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public static class Builder {
        private String instanceConsoleHistoryId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleHistoryRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleHistoryRequest build() {
            GetConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public GetConsoleHistoryRequest buildWithoutInvocationCallback() {
            return new GetConsoleHistoryRequest(this.instanceConsoleHistoryId);
        }

        public String toString() {
            return "GetConsoleHistoryRequest.Builder(instanceConsoleHistoryId=" + this.instanceConsoleHistoryId + ")";
        }
    }
}

