/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetCpeRequest
extends BmcRequest {
    private String cpeId;

    @ConstructorProperties(value={"cpeId"})
    GetCpeRequest(String cpeId) {
        this.cpeId = cpeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public static class Builder {
        private String cpeId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCpeRequest o) {
            this.cpeId(o.getCpeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCpeRequest build() {
            GetCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public GetCpeRequest buildWithoutInvocationCallback() {
            return new GetCpeRequest(this.cpeId);
        }

        public String toString() {
            return "GetCpeRequest.Builder(cpeId=" + this.cpeId + ")";
        }
    }
}

