/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetCrossConnectGroupRequest
extends BmcRequest {
    private String crossConnectGroupId;

    @ConstructorProperties(value={"crossConnectGroupId"})
    GetCrossConnectGroupRequest(String crossConnectGroupId) {
        this.crossConnectGroupId = crossConnectGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectGroupId() {
        return this.crossConnectGroupId;
    }

    public static class Builder {
        private String crossConnectGroupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCrossConnectGroupRequest o) {
            this.crossConnectGroupId(o.getCrossConnectGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCrossConnectGroupRequest build() {
            GetCrossConnectGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder crossConnectGroupId(String crossConnectGroupId) {
            this.crossConnectGroupId = crossConnectGroupId;
            return this;
        }

        public GetCrossConnectGroupRequest buildWithoutInvocationCallback() {
            return new GetCrossConnectGroupRequest(this.crossConnectGroupId);
        }

        public String toString() {
            return "GetCrossConnectGroupRequest.Builder(crossConnectGroupId=" + this.crossConnectGroupId + ")";
        }
    }
}

