/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetCrossConnectStatusRequest
extends BmcRequest {
    private String crossConnectId;

    @ConstructorProperties(value={"crossConnectId"})
    GetCrossConnectStatusRequest(String crossConnectId) {
        this.crossConnectId = crossConnectId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public static class Builder {
        private String crossConnectId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCrossConnectStatusRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCrossConnectStatusRequest build() {
            GetCrossConnectStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public GetCrossConnectStatusRequest buildWithoutInvocationCallback() {
            return new GetCrossConnectStatusRequest(this.crossConnectId);
        }

        public String toString() {
            return "GetCrossConnectStatusRequest.Builder(crossConnectId=" + this.crossConnectId + ")";
        }
    }
}

